/*
 * Decompiled with CFR 0.152.
 */
package com.rcx.materialis.datagen;

import com.rcx.materialis.MaterialisResources;
import com.rcx.materialis.datagen.MaterialisFluidTags;
import com.rcx.materialis.datagen.MaterialisItemTags;
import com.rcx.materialis.datagen.MaterialisMaterials;
import com.rcx.materialis.datagen.MaterialisModifiers;
import com.rcx.materialis.modifiers.CleansingModifier;
import com.rcx.materialis.util.MaterialisByproduct;
import java.util.ArrayList;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.crafting.ConditionalRecipe;
import net.minecraftforge.common.crafting.DifferenceIngredient;
import net.minecraftforge.common.crafting.IntersectionIngredient;
import net.minecraftforge.common.crafting.conditions.AndCondition;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionBuilder;
import net.minecraftforge.common.crafting.conditions.ModLoadedCondition;
import net.minecraftforge.common.crafting.conditions.NotCondition;
import net.minecraftforge.common.crafting.conditions.OrCondition;
import net.minecraftforge.common.crafting.conditions.TagEmptyCondition;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.recipe.data.ConsumerWrapperBuilder;
import slimeknights.mantle.recipe.data.ItemNameIngredient;
import slimeknights.mantle.recipe.ingredient.EntityIngredient;
import slimeknights.mantle.recipe.ingredient.SizedIngredient;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.fluids.TinkerFluids;
import slimeknights.tconstruct.library.data.recipe.IByproduct;
import slimeknights.tconstruct.library.data.recipe.ICommonRecipeHelper;
import slimeknights.tconstruct.library.data.recipe.IMaterialRecipeHelper;
import slimeknights.tconstruct.library.data.recipe.ISmelteryRecipeHelper;
import slimeknights.tconstruct.library.data.recipe.IToolRecipeHelper;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.modifiers.util.LazyModifier;
import slimeknights.tconstruct.library.recipe.alloying.AlloyRecipeBuilder;
import slimeknights.tconstruct.library.recipe.entitymelting.EntityMeltingRecipeBuilder;
import slimeknights.tconstruct.library.recipe.ingredient.MaterialIngredient;
import slimeknights.tconstruct.library.recipe.melting.MaterialMeltingRecipeBuilder;
import slimeknights.tconstruct.library.recipe.melting.MeltingRecipeBuilder;
import slimeknights.tconstruct.library.recipe.modifiers.ModifierMatch;
import slimeknights.tconstruct.library.recipe.modifiers.adding.ModifierRecipeBuilder;
import slimeknights.tconstruct.library.recipe.modifiers.adding.OverslimeModifierRecipeBuilder;
import slimeknights.tconstruct.library.recipe.modifiers.adding.SwappableModifierRecipeBuilder;
import slimeknights.tconstruct.library.tools.SlotType;
import slimeknights.tconstruct.library.tools.part.IMaterialItem;
import slimeknights.tconstruct.shared.TinkerCommons;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.tools.TinkerToolParts;
import slimeknights.tconstruct.tools.TinkerTools;
import slimeknights.tconstruct.tools.data.ModifierIds;

public class MaterialisRecipes
extends RecipeProvider
implements IConditionBuilder,
IMaterialRecipeHelper,
IToolRecipeHelper,
ISmelteryRecipeHelper,
ICommonRecipeHelper {
    public MaterialisRecipes(DataGenerator gen) {
        super(gen);
    }

    public String getModId() {
        return "materialis";
    }

    public void m_176531_(Consumer<FinishedRecipe> consumer) {
        for (MaterialisResources.IngotWithBlockNNugget material : MaterialisResources.materialList) {
            this.blockIngotNuggetCompression(consumer, material.name, (Item)material.BLOCK_ITEM.get(), (Item)material.INGOT.get(), (Item)material.NUGGET.get());
        }
        String castingFolder = "smeltery/casting/metal/";
        String meltingFolder = "smeltery/melting/metal/";
        String alloyFolder = "smeltery/alloys/";
        String materialFolder = "tools/materials/";
        String compositeFolder = "tools/parts/composite/";
        String modifierFolder = "tools/modifiers/";
        String salvageFolder = "tools/modifiers/salvage/";
        String slotlessFolder = "tools/modifiers/slotless/";
        String spillFolder = "tools/spilling/";
        String toolFolder = "tools/building/";
        String partFolder = "tools/parts/";
        String castFolder = "smeltery/casts/";
        String armorFolder = "armor/building/";
        String armorRepairFolder = "armor/repair/";
        this.metalCasting(consumer, MaterialisResources.FAIRY_FLUID.OBJECT, (ItemLike)MaterialisResources.FAIRY_INGOT.BLOCK.get(), (ItemLike)MaterialisResources.FAIRY_INGOT.INGOT.get(), (ItemLike)MaterialisResources.FAIRY_INGOT.NUGGET.get(), castingFolder, "fairy");
        this.metalMelting(consumer, (Fluid)MaterialisResources.FAIRY_FLUID.FLUID.get(), "fairy", false, meltingFolder, false, new IByproduct[0]);
        AlloyRecipeBuilder.alloy((Fluid)((Fluid)MaterialisResources.FAIRY_FLUID.FLUID.get()), (int)90).addInput((Fluid)TinkerFluids.moltenGold.get(), 90).addInput((Fluid)TinkerFluids.liquidSoul.get(), 1000).addInput(Tags.Fluids.MILK, 1000).save(consumer, this.prefix((Supplier)MaterialisResources.FAIRY_FLUID.FLUID, alloyFolder));
        this.partRecipes(consumer, (Supplier)MaterialisResources.WRENCH_HEAD, MaterialisResources.WRENCH_HEAD_CAST, 2, partFolder, castFolder);
        this.toolBuilding(consumer, (Supplier)MaterialisResources.WRENCH, toolFolder);
        this.toolBuilding(consumer, (Supplier)MaterialisResources.BATTLEWRENCH, toolFolder);
        this.metalTagCasting(consumer, MaterialisResources.REFINED_RADIANCE_FLUID.OBJECT, "refined_radiance", castingFolder, false);
        this.metalMelting(consumer, (Fluid)MaterialisResources.REFINED_RADIANCE_FLUID.FLUID.get(), "refined_radiance", false, meltingFolder, true, new IByproduct[0]);
        this.metalTagCasting(consumer, MaterialisResources.SHADOW_STEEL_FLUID.OBJECT, "shadow_steel", castingFolder, false);
        this.metalMelting(consumer, (Fluid)MaterialisResources.SHADOW_STEEL_FLUID.FLUID.get(), "shadow_steel", false, meltingFolder, true, new IByproduct[0]);
        this.metalTagCasting(consumer, MaterialisResources.ARCANE_GOLD_FLUID.OBJECT, "arcane_gold", castingFolder, false);
        this.metalMelting(consumer, (Fluid)MaterialisResources.ARCANE_GOLD_FLUID.FLUID.get(), "arcane_gold", false, meltingFolder, true, new IByproduct[0]);
        this.castCreation(this.withCondition(consumer, new ICondition[]{MaterialisRecipes.tagConditionDomain("forge", "inlays")}), MaterialisItemTags.INLAYS, MaterialisResources.INLAY_CAST, castFolder);
        this.tagCasting(consumer, TinkerFluids.moltenPewter, 180, MaterialisResources.INLAY_CAST, "inlays/pewter", castingFolder + "pewter_inlay", true);
        this.tagCasting(consumer, MaterialisResources.ARCANE_GOLD_FLUID.OBJECT, 180, MaterialisResources.INLAY_CAST, "inlays/arcane_gold", castingFolder + "arcane_gold_inlay", true);
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_204132_(MaterialisItemTags.PEWTER_INLAY), (Fluid)TinkerFluids.moltenPewter.get(), (int)180, (float)1.5f).save(this.withCondition(consumer, new ICondition[]{MaterialisRecipes.tagConditionDomain("forge", "inlays/pewter")}), this.modResource(meltingFolder + "pewter_inlay"));
        MeltingRecipeBuilder.melting((Ingredient)Ingredient.m_204132_(MaterialisItemTags.ARCANE_GOLD_INLAY), (Fluid)((Fluid)MaterialisResources.ARCANE_GOLD_FLUID.FLUID.get()), (int)180, (float)1.5f).save(this.withCondition(consumer, new ICondition[]{MaterialisRecipes.tagConditionDomain("forge", "inlays/arcane_gold")}), this.modResource(meltingFolder + "arcane_gold_inlay"));
        MeltingRecipeBuilder.melting((Ingredient)ItemNameIngredient.from((ResourceLocation[])new ResourceLocation[]{new ResourceLocation("eidolon", "pewter_blend")}), (Fluid)TinkerFluids.moltenPewter.get(), (int)90, (float)1.0f).save(this.withCondition(consumer, new ICondition[]{new ModLoadedCondition("eidolon")}), this.modResource(meltingFolder + "pewter_blend"));
        this.metalTagCasting(consumer, MaterialisResources.NEPTUNIUM_FLUID.OBJECT, "neptunium", castingFolder, false);
        this.metalMelting(consumer, (Fluid)MaterialisResources.NEPTUNIUM_FLUID.FLUID.get(), "neptunium", false, meltingFolder, true, new IByproduct[0]);
        this.toolMelting(this.withCondition(consumer, new ICondition[]{new ModLoadedCondition("aquaculture")}), new NameFluid("neptunium", (Fluid)MaterialisResources.NEPTUNIUM_FLUID.FLUID.get()), new ToolValue("aquaculture:neptunium_axe", 3.0), new ToolValue("aquaculture:neptunium_hoe", 2.0), new ToolValue("aquaculture:neptunium_pickaxe", 3.0), new ToolValue("aquaculture:neptunium_shovel", 1.0), new ToolValue("aquaculture:neptunium_sword", 2.0), new ToolValue("aquaculture:neptunium_bow", 3.0), new ToolValue("aquaculture:neptunium_fishing_rod", 2.0), new ToolValue("aquaculture:neptunium_fillet_knife", 2.0), new ToolValue("aquaculture:neptunium_helmet", 5.0), new ToolValue("aquaculture:neptunium_chestplate", 8.0), new ToolValue("aquaculture:neptunium_leggings", 7.0), new ToolValue("aquaculture:neptunium_boots", 4.0));
        this.multipleToolMelting(this.withCondition(consumer, new ICondition[]{new ModLoadedCondition("aquaculture")}), "aquaculture", new NameFluid[]{new NameFluid("iron", (Fluid)TinkerFluids.moltenIron.get()), new NameFluid("gold", (Fluid)TinkerFluids.moltenGold.get()), new NameFluid("diamond", (Fluid)TinkerFluids.moltenDiamond.get())}, new ToolValue("_fishing_rod", 2.0), new ToolValue("_fillet_knife", 2.0));
        this.metalTagCasting(consumer, MaterialisResources.QUICKSILVER_FLUID.OBJECT, "quicksilver", castingFolder, false);
        this.metalMelting(consumer, (Fluid)MaterialisResources.QUICKSILVER_FLUID.FLUID.get(), "quicksilver", true, meltingFolder, true, new IByproduct[]{MaterialisByproduct.ZINC, MaterialisByproduct.TIN});
        this.multipleToolMelting(this.withCondition(consumer, new ICondition[]{new ModLoadedCondition("mysticalworld")}), "mysticalworld", new NameFluid[]{new NameFluid("copper", (Fluid)TinkerFluids.moltenCopper.get()), new NameFluid("lead", (Fluid)TinkerFluids.moltenLead.get()), new NameFluid("quicksilver", (Fluid)MaterialisResources.QUICKSILVER_FLUID.FLUID.get()), new NameFluid("silver", (Fluid)TinkerFluids.moltenSilver.get()), new NameFluid("tin", (Fluid)TinkerFluids.moltenTin.get())}, new ToolValue("_axe", 3.0), new ToolValue("_hoe", 2.0), new ToolValue("_pickaxe", 3.0), new ToolValue("_shovel", 1.0), new ToolValue("_sword", 2.0), new ToolValue("_knife", 1.0), new ToolValue("_spear", 2.0), new ToolValue("_helmet", 5.0), new ToolValue("_chestplate", 8.0), new ToolValue("_leggings", 7.0), new ToolValue("_boots", 4.0));
        this.multipleToolMelting(this.withCondition(consumer, new ICondition[]{new ModLoadedCondition("mysticalworld")}), "mysticalworld", new NameFluid[]{new NameFluid("iron", (Fluid)TinkerFluids.moltenIron.get()), new NameFluid("gold", (Fluid)TinkerFluids.moltenGold.get()), new NameFluid("diamond", (Fluid)TinkerFluids.moltenDiamond.get())}, new ToolValue("_knife", 1.0), new ToolValue("_spear", 2.0));
        this.metalTagCasting(consumer, MaterialisResources.STARMETAL_FLUID.OBJECT, "starmetal", castingFolder, false);
        this.metalMelting(consumer, (Fluid)MaterialisResources.STARMETAL_FLUID.FLUID.get(), "starmetal", false, meltingFolder, true, new IByproduct[0]);
        this.metalTagCasting(consumer, MaterialisResources.PINK_SLIME_FLUID.OBJECT, "pink_slime", castingFolder, false);
        this.metalMelting(consumer, (Fluid)MaterialisResources.PINK_SLIME_FLUID.FLUID.get(), "pink_slime", false, meltingFolder, true, new IByproduct[0]);
        Consumer industrialForegoingLoaded = this.withCondition(consumer, new ICondition[]{new ModLoadedCondition("industrialforegoing")});
        AlloyRecipeBuilder.alloy((Fluid)((Fluid)MaterialisResources.PINK_SLIME_FLUID.FLUID.get()), (int)90).addInput((Fluid)TinkerFluids.moltenGold.get(), 180).addInput((Fluid)TinkerFluids.moltenIron.get(), 180).addInput(MaterialisFluidTags.LIQUID_PINK_SLIME, 1000).save(industrialForegoingLoaded, this.prefix((Supplier)MaterialisResources.PINK_SLIME_FLUID.FLUID, alloyFolder));
        this.metalTagCasting(consumer, MaterialisResources.CLOGGRUM_FLUID.OBJECT, "cloggrum", castingFolder, false);
        this.metalMelting(consumer, (Fluid)MaterialisResources.CLOGGRUM_FLUID.FLUID.get(), "cloggrum", true, meltingFolder, true, new IByproduct[]{MaterialisByproduct.FROSTSTEEL});
        this.metalTagCasting(consumer, MaterialisResources.FROSTSTEEL_FLUID.OBJECT, "froststeel", castingFolder, false);
        this.metalMelting(consumer, (Fluid)MaterialisResources.FROSTSTEEL_FLUID.FLUID.get(), "froststeel", true, meltingFolder, true, new IByproduct[]{MaterialisByproduct.REGALIUM});
        this.metalTagCasting(consumer, MaterialisResources.UTHERIUM_FLUID.OBJECT, "utherium", castingFolder, false);
        this.metalMelting(consumer, (Fluid)MaterialisResources.UTHERIUM_FLUID.FLUID.get(), "utherium", true, meltingFolder, true, new IByproduct[]{MaterialisByproduct.FROSTSTEEL});
        this.metalTagCasting(consumer, MaterialisResources.FORGOTTEN_FLUID.OBJECT, "forgotten_metal", castingFolder, false);
        this.metalMelting(consumer, (Fluid)MaterialisResources.FORGOTTEN_FLUID.FLUID.get(), "forgotten_metal", false, meltingFolder, true, new IByproduct[0]);
        this.metalTagCasting(consumer, MaterialisResources.REGALIUM_FLUID.OBJECT, "regalium", castingFolder, false);
        this.metalMelting(consumer, (Fluid)MaterialisResources.REGALIUM_FLUID.FLUID.get(), "regalium", true, meltingFolder, true, new IByproduct[]{MaterialisByproduct.CLOGGRUM});
        MeltingRecipeBuilder.melting((Ingredient)ItemNameIngredient.from((ResourceLocation[])new ResourceLocation[]{new ResourceLocation("undergarden", "utheric_shard")}), (Fluid)((Fluid)MaterialisResources.UTHERIUM_FLUID.FLUID.get()), (int)10, (float)1.0f).save(this.withCondition(consumer, new ICondition[]{new ModLoadedCondition("undergarden")}), this.modResource(meltingFolder + "utheric_shard"));
        EntityMeltingRecipeBuilder.melting((EntityIngredient)EntityIngredient.of(CleansingModifier.rotspawnTag), (FluidStack)new FluidStack((Fluid)MaterialisResources.UTHERIUM_FLUID.FLUID.get(), 1)).save(this.withCondition(consumer, new ICondition[]{new ModLoadedCondition("undergarden")}));
        this.multipleToolMelting(this.withCondition(consumer, new ICondition[]{new ModLoadedCondition("undergarden")}), "undergarden", new NameFluid[]{new NameFluid("cloggrum", (Fluid)MaterialisResources.CLOGGRUM_FLUID.FLUID.get()), new NameFluid("froststeel", (Fluid)MaterialisResources.FROSTSTEEL_FLUID.FLUID.get()), new NameFluid("utherium", (Fluid)MaterialisResources.UTHERIUM_FLUID.FLUID.get())}, new ToolValue("_axe", 3.0), new ToolValue("_hoe", 2.0), new ToolValue("_pickaxe", 3.0), new ToolValue("_shovel", 1.0), new ToolValue("_sword", 2.0), new ToolValue("_helmet", 5.0), new ToolValue("_chestplate", 8.0), new ToolValue("_leggings", 7.0), new ToolValue("_boots", 4.0));
        this.toolMelting(this.withCondition(consumer, new ICondition[]{new ModLoadedCondition("undergarden")}), new NameFluid("forgotten_metal", (Fluid)MaterialisResources.CLOGGRUM_FLUID.FLUID.get(), new FluidStack((Fluid)MaterialisResources.FORGOTTEN_FLUID.FLUID.get(), 90), true), new ToolValue("undergarden:forgotten_axe", 3.0), new ToolValue("undergarden:forgotten_hoe", 2.0), new ToolValue("undergarden:forgotten_pickaxe", 3.0), new ToolValue("undergarden:forgotten_shovel", 1.0), new ToolValue("undergarden:forgotten_sword", 2.0), new ToolValue("undergarden:forgotten_battleaxe", 3.0));
        this.toolMelting(this.withCondition(consumer, new ICondition[]{new ModLoadedCondition("undergarden")}), new NameFluid("cloggrum", (Fluid)MaterialisResources.CLOGGRUM_FLUID.FLUID.get()), new ToolValue("undergarden:cloggrum_shield", 6.0), new ToolValue("undergarden:cloggrum_battleaxe", 3.0));
        this.multipleToolMelting(this.withCondition(consumer, new ICondition[]{new ModLoadedCondition("mekanismtools")}), "mekanismtools", new NameFluid[]{new NameFluid("bronze", (Fluid)TinkerFluids.moltenBronze.get()), new NameFluid("osmium", (Fluid)TinkerFluids.moltenOsmium.get()), new NameFluid("refined_glowstone", (Fluid)TinkerFluids.moltenRefinedGlowstone.get()), new NameFluid("refined_obsidian", (Fluid)TinkerFluids.moltenRefinedObsidian.get()), new NameFluid("steel", (Fluid)TinkerFluids.moltenSteel.get())}, new ToolValue("_pickaxe", 3.0), new ToolValue("_axe", 3.0), new ToolValue("_shovel", 1.0), new ToolValue("_hoe", 2.0), new ToolValue("_sword", 2.0), new ToolValue("_paxel", 7.0), new ToolValue("_helmet", 5.0), new ToolValue("_chestplate", 8.0), new ToolValue("_leggings", 7.0), new ToolValue("_boots", 4.0));
        this.multipleToolMelting(this.withCondition(consumer, new ICondition[]{new ModLoadedCondition("mekanismtools")}), "mekanismtools", new NameFluid[]{new NameFluid("bronze", (Fluid)TinkerFluids.moltenBronze.get(), new FluidStack((Fluid)TinkerFluids.moltenIron.get(), 90), false), new NameFluid("osmium", (Fluid)TinkerFluids.moltenOsmium.get(), new FluidStack((Fluid)TinkerFluids.moltenIron.get(), 90), false), new NameFluid("refined_glowstone", (Fluid)TinkerFluids.moltenRefinedGlowstone.get(), new FluidStack((Fluid)TinkerFluids.moltenIron.get(), 90), false), new NameFluid("refined_obsidian", (Fluid)TinkerFluids.moltenRefinedObsidian.get(), new FluidStack((Fluid)TinkerFluids.moltenIron.get(), 90), false), new NameFluid("steel", (Fluid)TinkerFluids.moltenSteel.get(), new FluidStack((Fluid)TinkerFluids.moltenIron.get(), 90), false)}, new ToolValue("_shield", 6.0));
        this.multipleToolMelting(this.withCondition(consumer, new ICondition[]{new ModLoadedCondition("mekanismtools")}), "mekanismtools", new NameFluid[]{new NameFluid("iron", (Fluid)TinkerFluids.moltenIron.get()), new NameFluid("gold", (Fluid)TinkerFluids.moltenGold.get()), new NameFluid("diamond", (Fluid)TinkerFluids.moltenDiamond.get()), new NameFluid("netherite", (Fluid)TinkerFluids.moltenDiamond.get(), new FluidStack((Fluid)TinkerFluids.moltenNetherite.get(), 90), true)}, new ToolValue("_paxel", 7.0));
        Consumer psiLoaded = this.withCondition(consumer, new ICondition[]{new ModLoadedCondition("psi")});
        this.metalTagCasting(consumer, MaterialisResources.PSIMETAL_FLUID.OBJECT, "psimetal", castingFolder, false);
        this.metalMelting(consumer, (Fluid)MaterialisResources.PSIMETAL_FLUID.FLUID.get(), "psimetal", false, meltingFolder, true, new IByproduct[0]);
        this.metalTagCasting(consumer, MaterialisResources.EBONY_PSIMETAL_FLUID.OBJECT, "ebony_psimetal", castingFolder, false);
        this.metalMelting(consumer, (Fluid)MaterialisResources.EBONY_PSIMETAL_FLUID.FLUID.get(), "ebony_psimetal", false, meltingFolder, true, new IByproduct[0]);
        this.metalTagCasting(consumer, MaterialisResources.IVORY_PSIMETAL_FLUID.OBJECT, "ivory_psimetal", castingFolder, false);
        this.metalMelting(consumer, (Fluid)MaterialisResources.IVORY_PSIMETAL_FLUID.FLUID.get(), "ivory_psimetal", false, meltingFolder, true, new IByproduct[0]);
        this.toolMelting(this.withCondition(consumer, new ICondition[]{new AndCondition(new ICondition[]{new ModLoadedCondition("psi"), new NotCondition((ICondition)new ModLoadedCondition("magipsi"))})}), new NameFluid("psimetal", (Fluid)MaterialisResources.PSIMETAL_FLUID.FLUID.get(), new FluidStack((Fluid)TinkerFluids.moltenIron.get(), 180), false), new ToolValue("psi:psimetal_axe", 2.0), new ToolValue("psi:psimetal_pickaxe", 2.0), new ToolValue("psi:psimetal_shovel", 1.0));
        this.toolMelting(this.withCondition(consumer, new ICondition[]{new AndCondition(new ICondition[]{new ModLoadedCondition("psi"), new NotCondition((ICondition)new ModLoadedCondition("magipsi"))})}), new NameFluid("psimetal", (Fluid)MaterialisResources.PSIMETAL_FLUID.FLUID.get(), new FluidStack((Fluid)TinkerFluids.moltenIron.get(), 90), false), new ToolValue("psi:psimetal_sword", 1.0));
        this.toolMelting(this.withCondition(consumer, new ICondition[]{new ModLoadedCondition("magipsi")}), new NameFluid("psimetal_magical", (Fluid)MaterialisResources.PSIMETAL_FLUID.FLUID.get(), new FluidStack((Fluid)TinkerFluids.moltenGold.get(), 90), false), new ToolValue("psi:psimetal_axe", 2.0), new ToolValue("psi:psimetal_pickaxe", 2.0), new ToolValue("psi:psimetal_shovel", 1.0), new ToolValue("psi:psimetal_sword", 1.0));
        this.toolMelting(psiLoaded, new NameFluid("psimetal", (Fluid)MaterialisResources.PSIMETAL_FLUID.FLUID.get()), new ToolValue("psi:psimetal_exosuit_helmet", 3.0), new ToolValue("psi:psimetal_exosuit_chestplate", 6.0), new ToolValue("psi:psimetal_exosuit_leggings", 5.0), new ToolValue("psi:psimetal_exosuit_boots", 2.0));
        this.metalTagCasting(consumer, MaterialisResources.IESNIUM_FLUID.OBJECT, "iesnium", castingFolder, false);
        this.metalMelting(consumer, (Fluid)MaterialisResources.IESNIUM_FLUID.FLUID.get(), "iesnium", true, meltingFolder, true, new IByproduct[]{MaterialisByproduct.SILVER});
        this.toolMelting(this.withCondition(consumer, new ICondition[]{new ModLoadedCondition("occultism")}), new NameFluid("iesnium", (Fluid)MaterialisResources.IESNIUM_FLUID.FLUID.get()), new ToolValue("occultism:iesnium_pickaxe", 3.0));
        this.metalTagCasting(consumer, MaterialisResources.MANASTEEL_FLUID.OBJECT, "manasteel", castingFolder, false);
        this.metalMelting(consumer, (Fluid)MaterialisResources.MANASTEEL_FLUID.FLUID.get(), "manasteel", false, meltingFolder, true, new IByproduct[0]);
        this.metalTagCasting(consumer, MaterialisResources.ELEMENTIUM_FLUID.OBJECT, "elementium", castingFolder, false);
        this.metalMelting(consumer, (Fluid)MaterialisResources.ELEMENTIUM_FLUID.FLUID.get(), "elementium", true, meltingFolder, true, new IByproduct[]{MaterialisByproduct.GOLD});
        this.metalTagCasting(consumer, MaterialisResources.TERRASTEEL_FLUID.OBJECT, "terrasteel", castingFolder, false);
        this.metalMelting(consumer, (Fluid)MaterialisResources.TERRASTEEL_FLUID.FLUID.get(), "terrasteel", false, meltingFolder, true, new IByproduct[0]);
        this.multipleToolMelting(this.withCondition(consumer, new ICondition[]{new ModLoadedCondition("botania")}), "botania", new NameFluid[]{new NameFluid("manasteel", (Fluid)MaterialisResources.MANASTEEL_FLUID.FLUID.get()), new NameFluid("elementium", (Fluid)MaterialisResources.ELEMENTIUM_FLUID.FLUID.get())}, new ToolValue("_axe", 3.0), new ToolValue("_shovel", 1.0), new ToolValue("_hoe", 2.0), new ToolValue("_sword", 2.0), new ToolValue("_shears", 2.0), new ToolValue("_helmet", 5.0), new ToolValue("_chestplate", 8.0), new ToolValue("_leggings", 7.0), new ToolValue("_boots", 4.0));
        this.toolMelting(this.withCondition(consumer, new ICondition[]{new ModLoadedCondition("botania")}), new NameFluid("manasteel", (Fluid)MaterialisResources.MANASTEEL_FLUID.FLUID.get()), new ToolValue("botania:manasteel_pick", 3.0));
        this.toolMelting(this.withCondition(consumer, new ICondition[]{new ModLoadedCondition("botania")}), new NameFluid("elementium", (Fluid)MaterialisResources.ELEMENTIUM_FLUID.FLUID.get()), new ToolValue("botania:elementium_pickaxe", 3.0));
        this.toolMelting(this.withCondition(consumer, new ICondition[]{new ModLoadedCondition("botania")}), new NameFluid("terrasteel", (Fluid)MaterialisResources.MANASTEEL_FLUID.FLUID.get(), new FluidStack((Fluid)MaterialisResources.TERRASTEEL_FLUID.FLUID.get(), 270), true), new ToolValue("botania:terrasteel_helmet", 5.0), new ToolValue("botania:terrasteel_chestplate", 8.0), new ToolValue("botania:terrasteel_leggings", 7.0), new ToolValue("botania:terrasteel_boots", 4.0));
        this.toolMelting(this.withCondition(consumer, new ICondition[]{new ModLoadedCondition("botania")}), new NameFluid("terrasteel", (Fluid)MaterialisResources.TERRASTEEL_FLUID.FLUID.get()), new ToolValue("botania:terra_pick", 4.0), new ToolValue("botania:terra_axe", 4.0), new ToolValue("botania:terra_sword", 2.0));
        this.metalTagCasting(consumer, MaterialisResources.ALFSTEEL_FLUID.OBJECT, "alfsteel", castingFolder, false);
        this.metalMelting(consumer, (Fluid)MaterialisResources.ALFSTEEL_FLUID.FLUID.get(), "alfsteel", false, meltingFolder, true, new IByproduct[0]);
        this.toolMelting(this.withCondition(consumer, new ICondition[]{new ModLoadedCondition("mythicbotany")}), new NameFluid("alfsteel", (Fluid)MaterialisResources.TERRASTEEL_FLUID.FLUID.get(), new FluidStack((Fluid)MaterialisResources.ALFSTEEL_FLUID.FLUID.get(), 90), true), new ToolValue("mythicbotany:alfsteel_helmet", 3.0), new ToolValue("mythicbotany:alfsteel_chestplate", 3.0), new ToolValue("mythicbotany:alfsteel_leggings", 3.0), new ToolValue("mythicbotany:alfsteel_boots", 3.0));
        this.toolMelting(this.withCondition(consumer, new ICondition[]{new ModLoadedCondition("mythicbotany")}), new NameFluid("alfsteel", (Fluid)MaterialisResources.TERRASTEEL_FLUID.FLUID.get(), new FluidStack((Fluid)MaterialisResources.ALFSTEEL_FLUID.FLUID.get(), 90), true), new ToolValue("mythicbotany:alfsteel_pick", 4.0), new ToolValue("mythicbotany:alfsteel_axe", 4.0), new ToolValue("mythicbotany:alfsteel_sword", 2.0));
        this.metalTagCasting(consumer, MaterialisResources.DRACONIUM_FLUID.OBJECT, "draconium", castingFolder, false);
        this.metalMelting(consumer, (Fluid)MaterialisResources.DRACONIUM_FLUID.FLUID.get(), "draconium", true, meltingFolder, true, new IByproduct[]{MaterialisByproduct.PLATINUM, MaterialisByproduct.COBALT});
        this.metalTagCasting(consumer, MaterialisResources.AWAKENED_DRACONIUM_FLUID.OBJECT, "draconium_awakened", castingFolder, false);
        this.metalMelting(consumer, (Fluid)MaterialisResources.AWAKENED_DRACONIUM_FLUID.FLUID.get(), "draconium_awakened", false, meltingFolder, true, new IByproduct[0]);
        this.metalTagCasting(consumer, MaterialisResources.FLUX_INFUSED_FLUID.OBJECT, "flux_infused", castingFolder, false);
        this.metalMelting(consumer, (Fluid)MaterialisResources.FLUX_INFUSED_FLUID.FLUID.get(), "flux_infused", false, meltingFolder, true, new IByproduct[0]);
        this.metalMaterialRecipe(consumer, (MaterialVariantId)MaterialisMaterials.fairy, materialFolder, "fairy", false);
        this.metalMaterialRecipe(consumer, (MaterialVariantId)MaterialisMaterials.brass, materialFolder, "brass", true);
        this.metalMaterialRecipe(consumer, (MaterialVariantId)MaterialisMaterials.aluminum, materialFolder, "aluminum", true);
        this.metalMaterialRecipe(consumer, (MaterialVariantId)MaterialisMaterials.nickel, materialFolder, "nickel", true);
        this.metalMaterialRecipe(consumer, (MaterialVariantId)MaterialisMaterials.uranium, materialFolder, "uranium", true);
        this.materialRecipe(this.withCondition(consumer, new ICondition[]{new NotCondition((ICondition)new TagEmptyCondition(MaterialisItemTags.ROSE_QUARTZ_MATERIAL.f_203868_()))}), (MaterialVariantId)MaterialisMaterials.roseQuartz, Ingredient.m_204132_(MaterialisItemTags.ROSE_QUARTZ_MATERIAL), 1, 1, materialFolder + "rose_quartz");
        this.metalMaterialRecipe(consumer, (MaterialVariantId)MaterialisMaterials.refinedRadiance, materialFolder, "refined_radiance", true);
        this.metalMaterialRecipe(consumer, (MaterialVariantId)MaterialisMaterials.shadowSteel, materialFolder, "shadow_steel", true);
        this.metalMaterialRecipe(consumer, (MaterialVariantId)MaterialisMaterials.pewter, materialFolder, "pewter", true);
        this.metalMaterialRecipe(consumer, (MaterialVariantId)MaterialisMaterials.arcaneGold, materialFolder, "arcane_gold", true);
        this.metalMaterialRecipe(consumer, (MaterialVariantId)MaterialisMaterials.neptunium, materialFolder, "neptunium", true);
        this.metalMaterialRecipe(consumer, (MaterialVariantId)MaterialisMaterials.quicksilver, materialFolder, "quicksilver", true);
        this.metalMaterialRecipe(consumer, (MaterialVariantId)MaterialisMaterials.starmetal, materialFolder, "starmetal", true);
        this.materialRecipe(this.withCondition(consumer, new ICondition[]{new NotCondition((ICondition)new TagEmptyCondition(MaterialisItemTags.PLASTIC_MATERIAL.f_203868_()))}), (MaterialVariantId)MaterialisMaterials.plastic, Ingredient.m_204132_(MaterialisItemTags.PLASTIC_MATERIAL), 1, 1, materialFolder + "plastic");
        this.metalMaterialRecipe(consumer, (MaterialVariantId)MaterialisMaterials.pinkSlime, materialFolder, "pink_slime", true);
        this.metalMaterialRecipe(consumer, (MaterialVariantId)MaterialisMaterials.cloggrum, materialFolder, "cloggrum", true);
        this.metalMaterialRecipe(consumer, (MaterialVariantId)MaterialisMaterials.froststeel, materialFolder, "froststeel", true);
        this.metalMaterialRecipe(consumer, (MaterialVariantId)MaterialisMaterials.utherium, materialFolder, "utherium", true);
        this.metalMaterialRecipe(consumer, (MaterialVariantId)MaterialisMaterials.forgottenMetal, materialFolder, "forgotten_metal", true);
        this.metalMaterialRecipe(consumer, (MaterialVariantId)MaterialisMaterials.refinedObsidian, materialFolder, "refined_obsidian", true);
        this.metalMaterialRecipe(consumer, (MaterialVariantId)MaterialisMaterials.refinedGlowstone, materialFolder, "refined_glowstone", true);
        this.metalMaterialRecipe(consumer, (MaterialVariantId)MaterialisMaterials.psimetal, materialFolder, "psimetal", true);
        this.metalMaterialRecipe(consumer, (MaterialVariantId)MaterialisMaterials.ebonyPsimetal, materialFolder, "ebony_psimetal", true);
        this.metalMaterialRecipe(consumer, (MaterialVariantId)MaterialisMaterials.ivoryPsimetal, materialFolder, "ivory_psimetal", true);
        this.metalMaterialRecipe(consumer, (MaterialVariantId)MaterialisMaterials.iesnium, materialFolder, "iesnium", true);
        this.materialRecipe(this.withCondition(consumer, new ICondition[]{new ModLoadedCondition("botania")}), (MaterialVariantId)MaterialisMaterials.livingwood, Ingredient.m_204132_((TagKey)this.getItemTag("botania", "livingwood_logs")), 1, 1, materialFolder + "livingwood_log");
        this.materialRecipe(this.withCondition(consumer, new ICondition[]{new ModLoadedCondition("botania")}), (MaterialVariantId)MaterialisMaterials.livingwood, (Ingredient)ItemNameIngredient.from((ResourceLocation[])new ResourceLocation[]{new ResourceLocation("botania", "livingwood_planks")}), 1, 4, materialFolder + "livingwood_plank");
        this.materialRecipe(this.withCondition(consumer, new ICondition[]{new ModLoadedCondition("botania")}), (MaterialVariantId)MaterialisMaterials.livingwood, (Ingredient)ItemNameIngredient.from((ResourceLocation[])new ResourceLocation[]{new ResourceLocation("botania", "livingwood_twig")}), 2, 1, materialFolder + "livingwood_twig");
        this.materialRecipe(this.withCondition(consumer, new ICondition[]{new ModLoadedCondition("botania")}), (MaterialVariantId)MaterialisMaterials.dreamwood, Ingredient.m_204132_((TagKey)this.getItemTag("botania", "dreamwood_logs")), 1, 1, materialFolder + "dreamwood_log");
        this.materialRecipe(this.withCondition(consumer, new ICondition[]{new ModLoadedCondition("botania")}), (MaterialVariantId)MaterialisMaterials.dreamwood, (Ingredient)ItemNameIngredient.from((ResourceLocation[])new ResourceLocation[]{new ResourceLocation("botania", "dreamwood_planks")}), 1, 1, materialFolder + "dreamwood/plank");
        this.materialRecipe(this.withCondition(consumer, new ICondition[]{new ModLoadedCondition("botania")}), (MaterialVariantId)MaterialisMaterials.dreamwood, (Ingredient)ItemNameIngredient.from((ResourceLocation[])new ResourceLocation[]{new ResourceLocation("botania", "dreamwood_twig")}), 2, 1, materialFolder + "dreamwood/twig");
        this.metalMaterialRecipe(consumer, (MaterialVariantId)MaterialisMaterials.manasteel, materialFolder, "manasteel", true);
        this.metalMaterialRecipe(consumer, (MaterialVariantId)MaterialisMaterials.elementium, materialFolder, "elementium", true);
        this.metalMaterialRecipe(consumer, (MaterialVariantId)MaterialisMaterials.terrasteel, materialFolder, "terrasteel", true);
        this.metalMaterialRecipe(consumer, (MaterialVariantId)MaterialisMaterials.alfsteel, materialFolder, "alfsteel", true);
        this.metalMaterialRecipe(consumer, (MaterialVariantId)MaterialisMaterials.draconium, materialFolder, "draconium", true);
        this.metalMaterialRecipe(consumer, (MaterialVariantId)MaterialisMaterials.awakenedDraconium, materialFolder, "draconium_awakened", true);
        this.metalMaterialRecipe(consumer, (MaterialVariantId)MaterialisMaterials.fluxInfused, materialFolder, "flux_infused", true);
        this.materialMeltingCasting(consumer, (MaterialVariantId)MaterialisMaterials.fairy, MaterialisResources.FAIRY_FLUID.OBJECT, materialFolder);
        this.materialMeltingCasting(consumer, (MaterialVariantId)MaterialisMaterials.brass, TinkerFluids.moltenBrass, materialFolder);
        this.materialMeltingCasting(consumer, (MaterialVariantId)MaterialisMaterials.aluminum, TinkerFluids.moltenAluminum, materialFolder);
        this.materialMeltingCasting(consumer, (MaterialVariantId)MaterialisMaterials.nickel, TinkerFluids.moltenNickel, materialFolder);
        this.materialMeltingCasting(consumer, (MaterialVariantId)MaterialisMaterials.uranium, TinkerFluids.moltenUranium, materialFolder);
        this.materialMeltingCasting(consumer, (MaterialVariantId)MaterialisMaterials.refinedRadiance, MaterialisResources.REFINED_RADIANCE_FLUID.OBJECT, materialFolder);
        this.materialMeltingCasting(consumer, (MaterialVariantId)MaterialisMaterials.shadowSteel, MaterialisResources.SHADOW_STEEL_FLUID.OBJECT, materialFolder);
        this.materialMeltingCasting(consumer, (MaterialVariantId)MaterialisMaterials.pewter, TinkerFluids.moltenPewter, materialFolder);
        this.materialMeltingCasting(consumer, (MaterialVariantId)MaterialisMaterials.arcaneGold, MaterialisResources.ARCANE_GOLD_FLUID.OBJECT, materialFolder);
        this.materialMeltingCasting(consumer, (MaterialVariantId)MaterialisMaterials.neptunium, MaterialisResources.NEPTUNIUM_FLUID.OBJECT, materialFolder);
        this.materialMeltingCasting(consumer, (MaterialVariantId)MaterialisMaterials.quicksilver, MaterialisResources.QUICKSILVER_FLUID.OBJECT, materialFolder);
        this.materialMeltingCasting(consumer, (MaterialVariantId)MaterialisMaterials.starmetal, MaterialisResources.STARMETAL_FLUID.OBJECT, materialFolder);
        this.materialMeltingCasting(consumer, (MaterialVariantId)MaterialisMaterials.pinkSlime, MaterialisResources.PINK_SLIME_FLUID.OBJECT, materialFolder);
        this.materialMeltingCasting(consumer, (MaterialVariantId)MaterialisMaterials.cloggrum, MaterialisResources.CLOGGRUM_FLUID.OBJECT, materialFolder);
        this.materialMeltingCasting(consumer, (MaterialVariantId)MaterialisMaterials.froststeel, MaterialisResources.FROSTSTEEL_FLUID.OBJECT, materialFolder);
        this.materialMeltingCasting(consumer, (MaterialVariantId)MaterialisMaterials.utherium, MaterialisResources.UTHERIUM_FLUID.OBJECT, materialFolder);
        this.materialComposite(this.withCondition(consumer, new ICondition[]{new AndCondition(new ICondition[]{this.tagCondition("ingots/cloggrum"), this.tagCondition("ingots/forgotten_metal")})}), (MaterialVariantId)MaterialisMaterials.cloggrum, (MaterialVariantId)MaterialisMaterials.forgottenMetal, MaterialisResources.FORGOTTEN_FLUID.OBJECT, false, 30, compositeFolder);
        MaterialMeltingRecipeBuilder.material((MaterialVariantId)MaterialisMaterials.forgottenMetal, (FluidStack)new FluidStack((Fluid)MaterialisResources.FORGOTTEN_FLUID.FLUID.get(), 30)).save(this.withCondition(consumer, new ICondition[]{new AndCondition(new ICondition[]{this.tagCondition("ingots/cloggrum"), this.tagCondition("ingots/forgotten_metal")})}), this.modResource(materialFolder + "melting/forgotten_metal"));
        this.materialMeltingCasting(consumer, (MaterialVariantId)MaterialisMaterials.refinedObsidian, TinkerFluids.moltenRefinedObsidian, materialFolder);
        this.materialMeltingCasting(consumer, (MaterialVariantId)MaterialisMaterials.refinedGlowstone, TinkerFluids.moltenRefinedGlowstone, materialFolder);
        this.materialMeltingCasting(consumer, (MaterialVariantId)MaterialisMaterials.psimetal, MaterialisResources.PSIMETAL_FLUID.OBJECT, materialFolder);
        this.materialMeltingCasting(consumer, (MaterialVariantId)MaterialisMaterials.ebonyPsimetal, MaterialisResources.EBONY_PSIMETAL_FLUID.OBJECT, materialFolder);
        this.materialMeltingCasting(consumer, (MaterialVariantId)MaterialisMaterials.ivoryPsimetal, MaterialisResources.IVORY_PSIMETAL_FLUID.OBJECT, materialFolder);
        this.materialMeltingCasting(consumer, (MaterialVariantId)MaterialisMaterials.iesnium, MaterialisResources.IESNIUM_FLUID.OBJECT, materialFolder);
        this.materialMeltingCasting(consumer, (MaterialVariantId)MaterialisMaterials.manasteel, MaterialisResources.MANASTEEL_FLUID.OBJECT, materialFolder);
        this.materialMeltingCasting(consumer, (MaterialVariantId)MaterialisMaterials.elementium, MaterialisResources.ELEMENTIUM_FLUID.OBJECT, materialFolder);
        this.materialMeltingCasting(consumer, (MaterialVariantId)MaterialisMaterials.terrasteel, MaterialisResources.TERRASTEEL_FLUID.OBJECT, materialFolder);
        this.materialComposite(this.withCondition(consumer, new ICondition[]{new ModLoadedCondition("mythicbotany")}), (MaterialVariantId)MaterialisMaterials.terrasteel, (MaterialVariantId)MaterialisMaterials.alfsteel, MaterialisResources.ALFSTEEL_FLUID.OBJECT, false, 30, compositeFolder);
        MaterialMeltingRecipeBuilder.material((MaterialVariantId)MaterialisMaterials.alfsteel, (FluidStack)new FluidStack((Fluid)MaterialisResources.ALFSTEEL_FLUID.FLUID.get(), 30)).save(this.withCondition(consumer, new ICondition[]{new ModLoadedCondition("mythicbotany")}), this.modResource(materialFolder + "melting/alfsteel"));
        this.materialMeltingCasting(consumer, (MaterialVariantId)MaterialisMaterials.draconium, MaterialisResources.DRACONIUM_FLUID.OBJECT, materialFolder);
        this.materialMeltingCasting(consumer, (MaterialVariantId)MaterialisMaterials.awakenedDraconium, MaterialisResources.AWAKENED_DRACONIUM_FLUID.OBJECT, materialFolder);
        this.materialMeltingCasting(consumer, (MaterialVariantId)MaterialisMaterials.fluxInfused, MaterialisResources.FLUX_INFUSED_FLUID.OBJECT, materialFolder);
        ((ModifierRecipeBuilder)((ModifierRecipeBuilder)((ModifierRecipeBuilder)((ModifierRecipeBuilder)ModifierRecipeBuilder.modifier(MaterialisModifiers.reapingModifier).addInput(SizedIngredient.of((Ingredient)ItemNameIngredient.from((ResourceLocation[])new ResourceLocation[]{new ResourceLocation("eidolon", "tattered_cloth")}))).addInput(SizedIngredient.of((Ingredient)ItemNameIngredient.from((ResourceLocation[])new ResourceLocation[]{new ResourceLocation("eidolon", "unholy_symbol")}))).addInput(SizedIngredient.of((Ingredient)ItemNameIngredient.from((ResourceLocation[])new ResourceLocation[]{new ResourceLocation("eidolon", "tattered_cloth")}))).addInput(SizedIngredient.of((Ingredient)ItemNameIngredient.from((ResourceLocation[])new ResourceLocation[]{new ResourceLocation("eidolon", "soul_shard")}))).addInput(SizedIngredient.of((Ingredient)ItemNameIngredient.from((ResourceLocation[])new ResourceLocation[]{new ResourceLocation("eidolon", "soul_shard")}))).setTools(TinkerTags.Items.MELEE)).setMaxLevel(1)).setSlots(SlotType.ABILITY, 1)).includeUnarmed()).saveSalvage(consumer, this.prefix((ResourceLocation)MaterialisModifiers.reapingModifier.getId(), salvageFolder)).save(this.withCondition(consumer, new ICondition[]{new ModLoadedCondition("eidolon")}), this.prefix((ResourceLocation)MaterialisModifiers.reapingModifier.getId(), modifierFolder));
        OverslimeModifierRecipeBuilder.modifier((Ingredient)Ingredient.m_204132_(MaterialisItemTags.PINK_SLIME), (int)70).save(this.withCondition(consumer, new ICondition[]{new ModLoadedCondition("industrialforegoing")}), this.prefix((ResourceLocation)TinkerModifiers.overslime.getId(), modifierFolder));
        ((ModifierRecipeBuilder)((ModifierRecipeBuilder)((ModifierRecipeBuilder)SwappableModifierRecipeBuilder.modifier(MaterialisModifiers.runedModifier, (String)"rune").addInput(this.getItemTag("quark", "runes")).setTools(TinkerTags.Items.MODIFIABLE)).setRequirements(ModifierMatch.entry((ModifierId)ModifierIds.shiny))).setRequirementsError("recipe.materialis.modifier.runed_requirements")).saveSalvage(consumer, this.prefix((ResourceLocation)MaterialisModifiers.runedModifier.getId(), salvageFolder)).save(ConsumerWrapperBuilder.wrap((RecipeSerializer)((RecipeSerializer)MaterialisResources.runeModifierSerializer.get())).addCondition((ICondition)new ModLoadedCondition("quark")).build(consumer), this.prefix((ResourceLocation)MaterialisModifiers.runedModifier.getId(), modifierFolder));
        Ingredient interactableWithDurability = IntersectionIngredient.of((Ingredient[])new Ingredient[]{Ingredient.m_204132_((TagKey)TinkerTags.Items.DURABILITY), Ingredient.m_204132_((TagKey)TinkerTags.Items.INTERACTABLE)});
        ((ModifierRecipeBuilder)((ModifierRecipeBuilder)((ModifierRecipeBuilder)ModifierRecipeBuilder.modifier(MaterialisModifiers.wrenchingModifier).setTools((Ingredient)DifferenceIngredient.of((Ingredient)interactableWithDurability, (Ingredient)Ingredient.m_204132_(MaterialisItemTags.WRENCHING)))).addInput(SizedIngredient.of((Ingredient)MaterialIngredient.fromItem((IMaterialItem)((IMaterialItem)MaterialisResources.WRENCH_HEAD.get())))).addInput(TinkerTags.Items.INGOTS_NETHERITE_SCRAP).addInput(SizedIngredient.of((Ingredient)MaterialIngredient.fromItem((IMaterialItem)((IMaterialItem)TinkerToolParts.toolBinding.get())))).setMaxLevel(1)).setSlots(SlotType.ABILITY, 1)).saveSalvage(consumer, this.prefix((ResourceLocation)MaterialisModifiers.wrenchingModifier.getId(), salvageFolder)).save(consumer, this.prefix((ResourceLocation)MaterialisModifiers.wrenchingModifier.getId(), modifierFolder));
        ((ModifierRecipeBuilder)((ModifierRecipeBuilder)ModifierRecipeBuilder.modifier((ModifierId)MaterialisModifiers.galvanizedModifier).setTools(MaterialisItemTags.GALVANIZABLE)).addInput((ItemLike)Items.f_42714_).addInput(Tags.Items.INGOTS_IRON).setSlots(SlotType.UPGRADE, 2)).saveSalvage(consumer, this.prefix((ResourceLocation)MaterialisModifiers.galvanizedModifier, salvageFolder)).save(consumer, this.prefix((ResourceLocation)MaterialisModifiers.galvanizedModifier, modifierFolder));
        ModifierMatch wrenching = ModifierMatch.list((int)1, (ModifierMatch[])new ModifierMatch[]{ModifierMatch.entry(MaterialisModifiers.wrenchingModifier), ModifierMatch.entry(MaterialisModifiers.wrenchingModifierHidden)});
        ((ModifierRecipeBuilder)((ModifierRecipeBuilder)((ModifierRecipeBuilder)((ModifierRecipeBuilder)((ModifierRecipeBuilder)ModifierRecipeBuilder.modifier(MaterialisModifiers.thermalWrenchingModifier).setTools(interactableWithDurability)).addInput(this.getItemTag("forge", "gears/nickel")).addInput(SizedIngredient.of((Ingredient)ItemNameIngredient.from((ResourceLocation[])new ResourceLocation[]{new ResourceLocation("thermal", "wrench")}))).addInput(this.getItemTag("forge", "gears/nickel")).setRequirements(wrenching)).setRequirementsError("recipe.materialis.modifier.thermal_wrenching_requirements")).setMaxLevel(1)).setSlots(SlotType.UPGRADE, 1)).saveSalvage(consumer, this.prefix((ResourceLocation)MaterialisModifiers.thermalWrenchingModifier.getId(), salvageFolder)).save(this.withCondition(consumer, new ICondition[]{new ModLoadedCondition("thermal")}), this.prefix((ResourceLocation)MaterialisModifiers.thermalWrenchingModifier.getId(), modifierFolder));
        ((ModifierRecipeBuilder)((ModifierRecipeBuilder)((ModifierRecipeBuilder)((ModifierRecipeBuilder)((ModifierRecipeBuilder)ModifierRecipeBuilder.modifier(MaterialisModifiers.createWrenchingModifier).setTools(interactableWithDurability)).addInput(SizedIngredient.of((Ingredient)ItemNameIngredient.from((ResourceLocation[])new ResourceLocation[]{new ResourceLocation("create", "cogwheel")}))).addInput(SizedIngredient.of((Ingredient)ItemNameIngredient.from((ResourceLocation[])new ResourceLocation[]{new ResourceLocation("create", "wrench")}))).addInput(SizedIngredient.of((Ingredient)ItemNameIngredient.from((ResourceLocation[])new ResourceLocation[]{new ResourceLocation("create", "cogwheel")}))).setRequirements(wrenching)).setRequirementsError("recipe.materialis.modifier.create_wrenching_requirements")).setMaxLevel(1)).setSlots(SlotType.UPGRADE, 1)).saveSalvage(consumer, this.prefix((ResourceLocation)MaterialisModifiers.createWrenchingModifier.getId(), salvageFolder)).save(this.withCondition(consumer, new ICondition[]{new ModLoadedCondition("create")}), this.prefix((ResourceLocation)MaterialisModifiers.createWrenchingModifier.getId(), modifierFolder));
        ((ModifierRecipeBuilder)((ModifierRecipeBuilder)((ModifierRecipeBuilder)((ModifierRecipeBuilder)((ModifierRecipeBuilder)ModifierRecipeBuilder.modifier(MaterialisModifiers.immersiveWrenchingModifier).setTools(interactableWithDurability)).addInput(this.getItemTag("forge", "plates/copper")).addInput(SizedIngredient.of((Ingredient)ItemNameIngredient.from((ResourceLocation[])new ResourceLocation[]{new ResourceLocation("immersiveengineering", "hammer")}))).addInput(this.getItemTag("forge", "plates/copper")).setRequirements(wrenching)).setRequirementsError("recipe.materialis.modifier.immersive_wrenching_requirements")).setMaxLevel(1)).setSlots(SlotType.UPGRADE, 1)).saveSalvage(consumer, this.prefix((ResourceLocation)MaterialisModifiers.immersiveWrenchingModifier.getId(), salvageFolder)).save(this.withCondition(consumer, new ICondition[]{new ModLoadedCondition("immersiveengineering")}), this.prefix((ResourceLocation)MaterialisModifiers.immersiveWrenchingModifier.getId(), modifierFolder));
        ((ModifierRecipeBuilder)((ModifierRecipeBuilder)((ModifierRecipeBuilder)((ModifierRecipeBuilder)((ModifierRecipeBuilder)ModifierRecipeBuilder.modifier(MaterialisModifiers.pipeWrenchingModifier).setTools(interactableWithDurability)).addInput(SizedIngredient.of((Ingredient)ItemNameIngredient.from((ResourceLocation[])new ResourceLocation[]{new ResourceLocation("prettypipes", "pipe")}))).addInput(SizedIngredient.of((Ingredient)ItemNameIngredient.from((ResourceLocation[])new ResourceLocation[]{new ResourceLocation("prettypipes", "wrench")}))).addInput(SizedIngredient.of((Ingredient)ItemNameIngredient.from((ResourceLocation[])new ResourceLocation[]{new ResourceLocation("prettypipes", "pipe")}))).setRequirements(wrenching)).setRequirementsError("recipe.materialis.modifier.pipe_wrenching_requirements")).setMaxLevel(1)).setSlots(SlotType.UPGRADE, 1)).saveSalvage(consumer, this.prefix((ResourceLocation)MaterialisModifiers.pipeWrenchingModifier.getId(), salvageFolder)).save(this.withCondition(consumer, new ICondition[]{new ModLoadedCondition("prettypipes")}), this.prefix((ResourceLocation)MaterialisModifiers.pipeWrenchingModifier.getId(), modifierFolder));
        ((ModifierRecipeBuilder)((ModifierRecipeBuilder)ModifierRecipeBuilder.modifier(MaterialisModifiers.psionizingRadiationModifier).addInput(this.getItemTag("forge", "ingots/psimetal")).addInput(SizedIngredient.of((Ingredient)ItemNameIngredient.from((ResourceLocation[])new ResourceLocation[]{new ResourceLocation("psi", "cad_socket_basic")}))).addInput(this.getItemTag("forge", "ingots/psimetal")).addInput(this.getItemTag("forge", "gems/psigem")).addInput(this.getItemTag("forge", "gems/psigem")).setTools(TinkerTags.Items.HELD)).setSlots(SlotType.ABILITY, 1)).saveSalvage(consumer, this.prefix((ResourceLocation)MaterialisModifiers.psionizingRadiationModifier.getId(), salvageFolder)).save(psiLoaded, this.prefix((ResourceLocation)MaterialisModifiers.psionizingRadiationModifier.getId(), modifierFolder));
        ((ModifierRecipeBuilder)((ModifierRecipeBuilder)((ModifierRecipeBuilder)((ModifierRecipeBuilder)ModifierRecipeBuilder.modifier(MaterialisModifiers.spellCastingModifier).addInput(this.getItemTag("forge", "ingots/ebony_psimetal")).addInput(this.getItemTag("forge", "gems/psigem")).addInput(this.getItemTag("forge", "ingots/ivory_psimetal")).addInput(SizedIngredient.of((Ingredient)ItemNameIngredient.from((ResourceLocation[])new ResourceLocation[]{new ResourceLocation("psi", "cad_battery_ultradense")}))).addInput(SizedIngredient.of((Ingredient)ItemNameIngredient.from((ResourceLocation[])new ResourceLocation[]{new ResourceLocation("psi", "cad_assembly_psimetal")}))).setRequirements(ModifierMatch.list((int)1, (ModifierMatch[])new ModifierMatch[]{ModifierMatch.entry(MaterialisModifiers.psionizingRadiationModifier), ModifierMatch.entry(MaterialisModifiers.lesserPsionizingRadiationModifier)}))).setRequirementsError("recipe.materialis.modifier.casting_requirements")).setTools(TinkerTags.Items.HELD)).setSlots(SlotType.ABILITY, 1)).saveSalvage(consumer, this.prefix((ResourceLocation)MaterialisModifiers.spellCastingModifier.getId(), salvageFolder)).save(psiLoaded, this.prefix((ResourceLocation)MaterialisModifiers.spellCastingModifier.getId(), modifierFolder));
        ((ModifierRecipeBuilder)((ModifierRecipeBuilder)((ModifierRecipeBuilder)ModifierRecipeBuilder.modifier(MaterialisModifiers.spellSocketModifier).addInput(SizedIngredient.of((Ingredient)ItemNameIngredient.from((ResourceLocation[])new ResourceLocation[]{new ResourceLocation("psi", "cad_socket_basic")}))).setTools(TinkerTags.Items.MODIFIABLE)).setMaxLevel(5)).setSlots(SlotType.UPGRADE, 1)).saveSalvage(consumer, this.prefix((ResourceLocation)MaterialisModifiers.spellSocketModifier.getId(), salvageFolder)).save(psiLoaded, this.prefix((ResourceLocation)MaterialisModifiers.spellSocketModifier.getId(), modifierFolder));
        OrCondition capacitorIsUseful = new OrCondition(new ICondition[]{new ModLoadedCondition("draconicevolution"), new ModLoadedCondition("redstone_arsenal")});
        ((ModifierRecipeBuilder)((ModifierRecipeBuilder)((ModifierRecipeBuilder)ModifierRecipeBuilder.modifier(MaterialisModifiers.capacitorModifier).addInput(this.getItemTag("forge", "ingots/lead")).addInput(SizedIngredient.of((Ingredient)ItemNameIngredient.from((ResourceLocation[])new ResourceLocation[]{new ResourceLocation("thermal", "rf_coil")}))).addInput(this.getItemTag("forge", "ingots/lead")).setTools(TinkerTags.Items.MODIFIABLE)).setMaxLevel(5)).setSlots(SlotType.UPGRADE, 1)).saveSalvage(consumer, this.prefix((ResourceLocation)MaterialisModifiers.capacitorModifier.getId(), salvageFolder)).save(this.withCondition(consumer, new ICondition[]{new AndCondition(new ICondition[]{capacitorIsUseful, new ModLoadedCondition("thermal")})}), this.prefix((ResourceLocation)MaterialisModifiers.capacitorModifier.getId(), modifierFolder + "thermal_"));
        ((ModifierRecipeBuilder)((ModifierRecipeBuilder)((ModifierRecipeBuilder)ModifierRecipeBuilder.modifier(MaterialisModifiers.capacitorModifier).addInput(this.getItemTag("forge", "ingots/lead")).addInput(SizedIngredient.of((Ingredient)ItemNameIngredient.from((ResourceLocation[])new ResourceLocation[]{new ResourceLocation("immersiveengineering", "wirecoil_copper")}))).addInput(this.getItemTag("forge", "dusts/redstone")).setTools(TinkerTags.Items.MODIFIABLE)).setMaxLevel(5)).setSlots(SlotType.UPGRADE, 1)).save(this.withCondition(consumer, new ICondition[]{new AndCondition(new ICondition[]{capacitorIsUseful, new ModLoadedCondition("immersiveengineering")})}), this.prefix((ResourceLocation)MaterialisModifiers.capacitorModifier.getId(), modifierFolder + "immersiveengineering_"));
        ((ModifierRecipeBuilder)((ModifierRecipeBuilder)((ModifierRecipeBuilder)ModifierRecipeBuilder.modifier(MaterialisModifiers.capacitorModifier).addInput(SizedIngredient.of((Ingredient)ItemNameIngredient.from((ResourceLocation[])new ResourceLocation[]{new ResourceLocation("mekanism", "alloy_infused")}))).addInput(this.getItemTag("forge", "ingots/gold")).addInput(SizedIngredient.of((Ingredient)ItemNameIngredient.from((ResourceLocation[])new ResourceLocation[]{new ResourceLocation("mekanism", "alloy_infused")}))).setTools(TinkerTags.Items.MODIFIABLE)).setMaxLevel(5)).setSlots(SlotType.UPGRADE, 1)).save(this.withCondition(consumer, new ICondition[]{new AndCondition(new ICondition[]{capacitorIsUseful, new ModLoadedCondition("mekanism")})}), this.prefix((ResourceLocation)MaterialisModifiers.capacitorModifier.getId(), modifierFolder + "mekanism_"));
        ((ModifierRecipeBuilder)((ModifierRecipeBuilder)((ModifierRecipeBuilder)ModifierRecipeBuilder.modifier(MaterialisModifiers.capacitorModifier).addInput(this.getItemTag("forge", "dusts/redstone")).addInput(SizedIngredient.of((Ingredient)ItemNameIngredient.from((ResourceLocation[])new ResourceLocation[]{new ResourceLocation("draconicevolution", "draconium_core")}))).addInput(this.getItemTag("forge", "dusts/redstone")).setTools(TinkerTags.Items.MODIFIABLE)).setMaxLevel(5)).setSlots(SlotType.UPGRADE, 1)).save(this.withCondition(consumer, new ICondition[]{capacitorIsUseful}), this.prefix((ResourceLocation)MaterialisModifiers.capacitorModifier.getId(), modifierFolder + "draconicevolution_"));
        ((ModifierRecipeBuilder)((ModifierRecipeBuilder)SwappableModifierRecipeBuilder.modifier(MaterialisModifiers.psionizingRadiationModifierSensor, (String)"sensor").setTools(MaterialisItemTags.SENSOR_SLOTTABLE)).addInput(MaterialisItemTags.SENSOR).setSlots(MaterialisResources.SENSOR_SLOT, 1)).saveSalvage(psiLoaded, this.prefix((ResourceLocation)MaterialisModifiers.psionizingRadiationModifierSensor.getId(), salvageFolder)).save(ConsumerWrapperBuilder.wrap((RecipeSerializer)((RecipeSerializer)MaterialisResources.sensorModifierSerializer.get())).addCondition((ICondition)new ModLoadedCondition("psi")).build(consumer), this.prefix((ResourceLocation)MaterialisModifiers.psionizingRadiationModifierSensor.getId(), modifierFolder));
        ((ModifierRecipeBuilder)((ModifierRecipeBuilder)((ModifierRecipeBuilder)ModifierRecipeBuilder.modifier(MaterialisModifiers.engineersGogglesModifier).setTools(TinkerTags.Items.HELMETS)).addInput(SizedIngredient.of((Ingredient)ItemNameIngredient.from((ResourceLocation[])new ResourceLocation[]{new ResourceLocation("create", "goggles")}))).setMaxLevel(1)).setSlots(SlotType.UPGRADE, 1)).saveSalvage(consumer, this.prefix((ResourceLocation)MaterialisModifiers.engineersGogglesModifier.getId(), salvageFolder)).save(this.withCondition(consumer, new ICondition[]{new ModLoadedCondition("create")}), this.prefix((ResourceLocation)MaterialisModifiers.engineersGogglesModifier.getId(), modifierFolder));
        ((ModifierRecipeBuilder)((ModifierRecipeBuilder)((ModifierRecipeBuilder)ModifierRecipeBuilder.modifier(MaterialisModifiers.otherworldGogglesModifier).setTools(TinkerTags.Items.HELMETS)).addInput(SizedIngredient.of((Ingredient)ItemNameIngredient.from((ResourceLocation[])new ResourceLocation[]{new ResourceLocation("occultism", "otherworld_goggles")}))).setMaxLevel(1)).setSlots(SlotType.ABILITY, 1)).saveSalvage(consumer, this.prefix((ResourceLocation)MaterialisModifiers.otherworldGogglesModifier.getId(), salvageFolder)).save(this.withCondition(consumer, new ICondition[]{new ModLoadedCondition("occultism")}), this.prefix((ResourceLocation)MaterialisModifiers.otherworldGogglesModifier.getId(), modifierFolder));
        ((ModifierRecipeBuilder)((ModifierRecipeBuilder)((ModifierRecipeBuilder)((ModifierRecipeBuilder)ModifierRecipeBuilder.modifier(MaterialisModifiers.reactiveModifier).setTools(TinkerTags.Items.MODIFIABLE)).addInput(SizedIngredient.of((Ingredient)ItemNameIngredient.from((ResourceLocation[])new ResourceLocation[]{new ResourceLocation("ars_nouveau", "source_gem")}))).addInput(Tags.Items.STORAGE_BLOCKS_LAPIS).addInput(SizedIngredient.of((Ingredient)ItemNameIngredient.from((ResourceLocation[])new ResourceLocation[]{new ResourceLocation("ars_nouveau", "source_gem")}))).addInput(SizedIngredient.of((Ingredient)ItemNameIngredient.from((ResourceLocation[])new ResourceLocation[]{new ResourceLocation("ars_nouveau", "source_gem")}))).addInput(SizedIngredient.of((Ingredient)ItemNameIngredient.from((ResourceLocation[])new ResourceLocation[]{new ResourceLocation("ars_nouveau", "source_gem")}))).setSalvageLevelRange(1, 1)).setMaxLevel(1)).setSlots(SlotType.ABILITY, 1)).saveSalvage(consumer, this.wrap((ResourceLocation)MaterialisModifiers.reactiveModifier.getId(), salvageFolder, "_level_1")).save(this.withCondition(consumer, new ICondition[]{new ModLoadedCondition("ars_nouveau")}), this.wrap((ResourceLocation)MaterialisModifiers.reactiveModifier.getId(), modifierFolder, "_level_1"));
        ((ModifierRecipeBuilder)((ModifierRecipeBuilder)((ModifierRecipeBuilder)((ModifierRecipeBuilder)((ModifierRecipeBuilder)ModifierRecipeBuilder.modifier(MaterialisModifiers.reactiveModifier).setTools(TinkerTags.Items.MODIFIABLE)).addInput(SizedIngredient.of((Ingredient)ItemNameIngredient.from((ResourceLocation[])new ResourceLocation[]{new ResourceLocation("ars_nouveau", "air_essence")}))).addInput(Tags.Items.RODS_BLAZE).addInput(SizedIngredient.of((Ingredient)ItemNameIngredient.from((ResourceLocation[])new ResourceLocation[]{new ResourceLocation("ars_nouveau", "fire_essence")}))).addInput(SizedIngredient.of((Ingredient)ItemNameIngredient.from((ResourceLocation[])new ResourceLocation[]{new ResourceLocation("ars_nouveau", "water_essence")}))).addInput(SizedIngredient.of((Ingredient)ItemNameIngredient.from((ResourceLocation[])new ResourceLocation[]{new ResourceLocation("ars_nouveau", "earth_essence")}))).setRequirements(ModifierMatch.entry(MaterialisModifiers.reactiveModifier, (int)1))).setRequirementsError("recipe.materialis.modifier.reactive_requirements")).setSalvageLevelRange(2, 2)).setMaxLevel(2)).saveSalvage(consumer, this.wrap((ResourceLocation)MaterialisModifiers.reactiveModifier.getId(), salvageFolder, "_level_2")).save(this.withCondition(consumer, new ICondition[]{new ModLoadedCondition("ars_nouveau")}), this.wrap((ResourceLocation)MaterialisModifiers.reactiveModifier.getId(), modifierFolder, "_level_2"));
        ((ModifierRecipeBuilder)((ModifierRecipeBuilder)((ModifierRecipeBuilder)((ModifierRecipeBuilder)((ModifierRecipeBuilder)ModifierRecipeBuilder.modifier(MaterialisModifiers.reactiveModifier).setTools(TinkerTags.Items.MODIFIABLE)).addInput(SizedIngredient.of((Ingredient)ItemNameIngredient.from((ResourceLocation[])new ResourceLocation[]{new ResourceLocation("ars_nouveau", "abjuration_essence")}))).addInput(SizedIngredient.of((Ingredient)ItemNameIngredient.from((ResourceLocation[])new ResourceLocation[]{new ResourceLocation("ars_nouveau", "conjuration_essence")}))).addInput(SizedIngredient.of((Ingredient)ItemNameIngredient.from((ResourceLocation[])new ResourceLocation[]{new ResourceLocation("ars_nouveau", "manipulation_essence")}))).addInput(Tags.Items.ENDER_PEARLS).addInput(this.getItemTag("forge", "ingots/cobalt")).setRequirements(ModifierMatch.entry(MaterialisModifiers.reactiveModifier, (int)2))).setRequirementsError("recipe.materialis.modifier.reactive_requirements")).setSalvageLevelRange(3, 3)).setMaxLevel(3)).saveSalvage(consumer, this.wrap((ResourceLocation)MaterialisModifiers.reactiveModifier.getId(), salvageFolder, "_level_3")).save(this.withCondition(consumer, new ICondition[]{new ModLoadedCondition("ars_nouveau")}), this.wrap((ResourceLocation)MaterialisModifiers.reactiveModifier.getId(), modifierFolder, "_level_3"));
        ((ModifierRecipeBuilder)((ModifierRecipeBuilder)((ModifierRecipeBuilder)((ModifierRecipeBuilder)((ModifierRecipeBuilder)ModifierRecipeBuilder.modifier(MaterialisModifiers.reactiveModifier).setTools(TinkerTags.Items.MODIFIABLE)).addInput(Tags.Items.ENDER_PEARLS).addInput(SizedIngredient.of((Ingredient)ItemNameIngredient.from((ResourceLocation[])new ResourceLocation[]{new ResourceLocation("ars_nouveau", "wilden_tribute")}))).addInput((ItemLike)TinkerCommons.jeweledApple).setRequirements(ModifierMatch.entry(MaterialisModifiers.reactiveModifier, (int)3))).setRequirementsError("recipe.materialis.modifier.reactive_requirements")).setSalvageLevelRange(4, 4)).setMaxLevel(4)).saveSalvage(consumer, this.wrap((ResourceLocation)MaterialisModifiers.reactiveModifier.getId(), salvageFolder, "_level_4")).save(this.withCondition(consumer, new ICondition[]{new ModLoadedCondition("ars_nouveau")}), this.wrap((ResourceLocation)MaterialisModifiers.reactiveModifier.getId(), modifierFolder, "_level_4"));
        ArrayList armorItems = new ArrayList();
        armorItems.addAll(TinkerTools.plateArmor.values());
        Ingredient armor = Ingredient.m_43921_(armorItems.stream().map(ItemStack::new));
        this.plateTexture(consumer, armor, MaterialisMaterials.fairy, false, slotlessFolder);
        this.plateTexture(consumer, armor, MaterialisMaterials.refinedRadiance, true, slotlessFolder);
        this.plateTexture(consumer, armor, MaterialisMaterials.shadowSteel, true, slotlessFolder);
        this.plateTexture(consumer, armor, MaterialisMaterials.pewter, true, slotlessFolder);
        this.plateTexture(consumer, armor, MaterialisMaterials.arcaneGold, true, slotlessFolder);
        this.plateTexture(consumer, armor, MaterialisMaterials.neptunium, true, slotlessFolder);
        this.plateTexture(consumer, armor, MaterialisMaterials.quicksilver, true, slotlessFolder);
        this.plateTexture(consumer, armor, MaterialisMaterials.starmetal, true, slotlessFolder);
        this.plateTexture(consumer, armor, MaterialisMaterials.pinkSlime, true, slotlessFolder);
        this.plateTexture(consumer, armor, MaterialisMaterials.cloggrum, true, slotlessFolder);
        this.plateTexture(consumer, armor, MaterialisMaterials.froststeel, true, slotlessFolder);
        this.plateTexture(consumer, armor, MaterialisMaterials.utherium, true, slotlessFolder);
        this.plateTexture(consumer, armor, MaterialisMaterials.regalium, true, slotlessFolder);
        this.plateTexture(consumer, armor, MaterialisMaterials.forgottenMetal, true, slotlessFolder);
        this.plateTexture(consumer, armor, MaterialisMaterials.refinedObsidian, true, slotlessFolder);
        this.plateTexture(consumer, armor, MaterialisMaterials.refinedGlowstone, true, slotlessFolder);
        this.plateTexture(consumer, armor, MaterialisMaterials.psimetal, true, slotlessFolder);
        this.plateTexture(consumer, armor, MaterialisMaterials.ebonyPsimetal, true, slotlessFolder);
        this.plateTexture(consumer, armor, MaterialisMaterials.ivoryPsimetal, true, slotlessFolder);
        this.plateTexture(consumer, armor, MaterialisMaterials.iesnium, true, slotlessFolder);
        this.plateTexture(consumer, armor, MaterialisMaterials.manasteel, true, slotlessFolder);
        this.plateTexture(consumer, armor, MaterialisMaterials.elementium, true, slotlessFolder);
        this.plateTexture(consumer, armor, MaterialisMaterials.terrasteel, true, slotlessFolder);
        this.plateTexture(consumer, armor, MaterialisMaterials.alfsteel, true, slotlessFolder);
        this.plateTexture(consumer, armor, MaterialisMaterials.draconium, true, slotlessFolder);
        this.plateTexture(consumer, armor, MaterialisMaterials.awakenedDraconium, true, slotlessFolder);
        this.plateTexture(consumer, armor, MaterialisMaterials.fluxInfused, true, slotlessFolder);
        Ingredient slimesuit = Ingredient.m_43921_(TinkerTools.slimesuit.values().stream().map(ItemStack::new));
        ((ModifierRecipeBuilder)SwappableModifierRecipeBuilder.modifier((LazyModifier)TinkerModifiers.embellishment, (String)MaterialisMaterials.pinkSlimeball.toString()).setTools(slimesuit)).addInput(Ingredient.m_204132_(MaterialisItemTags.PINK_SLIME)).addInput(Ingredient.m_204132_(MaterialisItemTags.PINK_SLIME)).addInput(Ingredient.m_204132_(MaterialisItemTags.PINK_SLIME)).addInput(Ingredient.m_204132_(MaterialisItemTags.PINK_SLIME)).addInput(Ingredient.m_204132_(MaterialisItemTags.PINK_SLIME)).save(industrialForegoingLoaded, this.wrap((ResourceLocation)TinkerModifiers.embellishment.getId(), slotlessFolder, "_pink_slimeball"));
    }

    public void blockIngotNuggetCompression(Consumer<FinishedRecipe> consumer, String name, Item block, Item ingot, Item nugget) {
        ConditionalRecipe.builder().addCondition(this.TRUE()).addRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.m_126118_((ItemLike)block, (int)1).m_126130_("XXX").m_126130_("XYX").m_126130_("XXX").m_206416_(Character.valueOf('X'), ItemTags.create((ResourceLocation)new ResourceLocation("forge", "ingots/" + name))).m_126127_(Character.valueOf('Y'), (ItemLike)ingot).m_142409_("").m_142284_("has_ingot", (CriterionTriggerInstance)MaterialisRecipes.m_125977_((ItemLike)ingot))).m_176498_(arg_0)).generateAdvancement().build(consumer, new ResourceLocation("materialis", ingot.getRegistryName().m_135815_() + "_to_block"));
        ConditionalRecipe.builder().addCondition(this.TRUE()).addRecipe(arg_0 -> ((ShapelessRecipeBuilder)ShapelessRecipeBuilder.m_126191_((ItemLike)ingot, (int)9).m_126209_((ItemLike)block).m_142409_("").m_142284_("has_block", (CriterionTriggerInstance)MaterialisRecipes.m_125977_((ItemLike)block))).m_176498_(arg_0)).generateAdvancement().build(consumer, new ResourceLocation("materialis", block.getRegistryName().m_135815_() + "_to_ingot"));
        ConditionalRecipe.builder().addCondition(this.TRUE()).addRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.m_126118_((ItemLike)ingot, (int)1).m_126130_("XXX").m_126130_("XYX").m_126130_("XXX").m_206416_(Character.valueOf('X'), ItemTags.create((ResourceLocation)new ResourceLocation("forge", "nuggets/" + name))).m_126127_(Character.valueOf('Y'), (ItemLike)nugget).m_142409_("").m_142284_("has_nugget", (CriterionTriggerInstance)MaterialisRecipes.m_125977_((ItemLike)nugget))).m_176498_(arg_0)).generateAdvancement().build(consumer, new ResourceLocation("materialis", nugget.getRegistryName().m_135815_() + "_to_ingot"));
        ConditionalRecipe.builder().addCondition(this.TRUE()).addRecipe(arg_0 -> ((ShapelessRecipeBuilder)ShapelessRecipeBuilder.m_126191_((ItemLike)nugget, (int)9).m_126209_((ItemLike)ingot).m_142409_("").m_142284_("has_ingot", (CriterionTriggerInstance)MaterialisRecipes.m_125977_((ItemLike)ingot))).m_176498_(arg_0)).generateAdvancement().build(consumer, new ResourceLocation("materialis", ingot.getRegistryName().m_135815_() + "_to_nugget"));
    }

    private void plateTexture(Consumer<FinishedRecipe> consumer, Ingredient tool, MaterialId material, boolean optional, String folder) {
        this.plateTexture(consumer, tool, material, "ingots/" + material.m_135815_(), optional, folder);
    }

    private void plateTexture(Consumer<FinishedRecipe> consumer, Ingredient tool, MaterialId material, String tag, boolean optional, String folder) {
        Ingredient ingot = Ingredient.m_204132_((TagKey)ItemTags.create((ResourceLocation)new ResourceLocation("forge", tag)));
        if (optional) {
            consumer = this.withCondition(consumer, new ICondition[]{this.tagCondition(tag)});
        }
        ((ModifierRecipeBuilder)SwappableModifierRecipeBuilder.modifier((LazyModifier)TinkerModifiers.embellishment, (String)material.toString()).setTools(tool)).addInput(ingot).addInput(ingot).addInput(ingot).save(consumer, this.wrap((ResourceLocation)TinkerModifiers.embellishment.getId(), folder, "_" + material.m_135815_()));
    }

    protected static ICondition tagConditionDomain(String domain, String name) {
        return new NotCondition((ICondition)new TagEmptyCondition(domain, name));
    }

    public void multipleToolMelting(Consumer<FinishedRecipe> consumer, String modID, NameFluid[] names, ToolValue ... values) {
        for (NameFluid name : names) {
            for (ToolValue value : values) {
                this.toolMelting(consumer, name, new ToolValue(modID + ":" + name.name + value.toolID, value.ingotValue));
            }
        }
    }

    public void toolMelting(Consumer<FinishedRecipe> consumer, NameFluid name, ToolValue ... values) {
        for (ToolValue value : values) {
            ResourceLocation toolLocation = new ResourceLocation(value.toolID);
            if (name.byproduct == null) {
                MeltingRecipeBuilder.melting((Ingredient)ItemNameIngredient.from((ResourceLocation[])new ResourceLocation[]{toolLocation}), (Fluid)name.fluid, (int)((int)(90.0 * value.ingotValue))).setDamagable().save(consumer, this.modResource("smeltery/melting/metal/tools/" + name.name + "/" + toolLocation.m_135815_()));
                continue;
            }
            if (!name.byproductIsMain) {
                MeltingRecipeBuilder.melting((Ingredient)ItemNameIngredient.from((ResourceLocation[])new ResourceLocation[]{toolLocation}), (Fluid)name.fluid, (int)((int)(90.0 * value.ingotValue))).addByproduct(name.byproduct).setDamagable().save(consumer, this.modResource("smeltery/melting/metal/tools/" + name.name + "/" + toolLocation.m_135815_()));
                continue;
            }
            MeltingRecipeBuilder.melting((Ingredient)ItemNameIngredient.from((ResourceLocation[])new ResourceLocation[]{toolLocation}), (Fluid)name.byproduct.getFluid(), (int)name.byproduct.getAmount()).addByproduct(new FluidStack(name.fluid, (int)(90.0 * value.ingotValue))).setDamagable().save(consumer, this.modResource("smeltery/melting/metal/tools/" + name.name + "/" + toolLocation.m_135815_()));
        }
    }

    public static class NameFluid {
        public String name;
        public Fluid fluid;
        public FluidStack byproduct = null;
        public boolean byproductIsMain = false;

        public NameFluid(String name, Fluid fluid) {
            this.name = name;
            this.fluid = fluid;
        }

        public NameFluid(String name, Fluid fluid, FluidStack byproduct, boolean byproductIsMain) {
            this(name, fluid);
            this.byproduct = byproduct;
            this.byproductIsMain = byproductIsMain;
        }
    }

    public static class ToolValue {
        public String toolID;
        public Double ingotValue;

        public ToolValue(String toolID, double ingotValue) {
            this.toolID = toolID;
            this.ingotValue = ingotValue;
        }
    }
}

